USE [BMS]
GO

/****** Object:  StoredProcedure [dbo].[usp_Update_WaitingListItem]    Script Date: 4/13/2016 3:44:31 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		PII
-- Create date: 31.08.2011
-- Description:	Update waiting list item by id.
-- =============================================
ALTER PROCEDURE [dbo].[usp_Update_WaitingListItem] 
	@ACT_ID	INT OUTPUT,
	@CREATION_DATE DATETIME,
	@CANCELED_DATE DATETIME,
	@PARENT_ACT_ID INT,
	@FLOW_ID UNIQUEIDENTIFIER,
	@DOMAIN_ID VARCHAR(50),
	@PATIENT_UID UNIQUEIDENTIFIER,
	@IEN VARCHAR(50),
	@FACILITY_UID UNIQUEIDENTIFIER,
	@PROBLEM VARCHAR(MAX),
	@FEE_COMMENTS VARCHAR(150),
	@REMOVED_DATE DATETIME,
	@WAITING_AREA_CODE VARCHAR(100),
	@WAITING_AREA_CODE_SYSTEM VARCHAR(100),
	@WAITING_AREA_CODE_SYSTEM_NAME VARCHAR(100),
	@WAITING_AREA_DISPLAY_NAME VARCHAR(250),
	@REASON_USING_FEE_CODE VARCHAR(100),
	@REASON_USING_FEE_CODE_SYSTEM VARCHAR(100),
	@REASON_USING_FEE_CODE_SYSTEM_NAME VARCHAR(100),
	@REASON_USING_FEE_DISPLAY_NAME VARCHAR(250),
	@SERVICE_RECEIVING_FEE_CODE	VARCHAR(100),
	@SERVICE_RECEIVING_FEE_CODE_SYSTEM VARCHAR(100),
	@SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME	VARCHAR(100),
	@SERVICE_RECEIVING_FEE_DISPLAY_NAME	VARCHAR(250),
	@AUTHORIZED_FEE_CODE VARCHAR(100),
	@AUTHORIZED_FEE_CODE_SYSTEM	VARCHAR(100),
	@AUTHORIZED_FEE_CODE_SYSTEM_NAME VARCHAR(100),
	@AUTHORIZED_FEE_DISPLAY_NAME VARCHAR(250),
	@CONTRACT_FEE_CODE VARCHAR(100),
	@CONTRACT_FEE_CODE_SYSTEM VARCHAR(100),
	@CONTRACT_FEE_CODE_SYSTEM_NAME VARCHAR(100),
	@CONTRACT_FEE_DISPLAY_NAME VARCHAR(250),
	@FEE_DISPOSITION_CODE VARCHAR(100),
	@FEE_DISPOSITION_CODE_SYSTEM VARCHAR(100),
	@FEE_DISPOSITION_CODE_SYSTEM_NAME VARCHAR(100),
	@FEE_DISPOSITION_DISPLAY_NAME VARCHAR(250),
	@TYPE_OF_BED_WARD VARCHAR(MAX),
	@REQUESTED_BED_UID UNIQUEIDENTIFIER,
	@REQUESTED_BED_DATE DATETIME,
	@REQUESTED_DATE DATETIME,
	@VISTA_SITE_UID UNIQUEIDENTIFIER,
	@IS_IN_HOUSE BIT,
	@LAST_EDIT_BY NVARCHAR(100),
	@COMMENTS VARCHAR(150),
	@IS_BED_IN_ISOLATION BIT,
	@WAIT_TIME_ALERT_DATE DATETIME,
	@IS_COMMUNITY_LIVING_CENTER BIT,
    @IS_EVACUATION_PATIENT BIT,
	@IS_MENTAL_HEALTH_PATIENT BIT,
	@EVACUATION_DISPOSITION_STATUS_CODE VARCHAR(100),
	@EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM VARCHAR(100),
	@EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM_NAME VARCHAR(100),
	@EVACUATION_DISPOSITION_STATUS_DISPLAY_NAME VARCHAR(100),
	@EVACUATION_EXPECTED_DATE DATETIME,
	@EVACUATION_ACTUAL_DATE DATETIME,
	@EVACUATION_REASON_FOR_DELAY NVARCHAR(250),
	@EVACUATION_TRANSFER_EVACUATE_TO NVARCHAR(250),
	@EVACUATION_EQUIP_SUPPLY_REQUIREMENTS NVARCHAR(250),
	@EVACUATION_TRANSPORTATION_CARE_LEVEL NVARCHAR(250),
	@EVACUATION_ENROUTE_MEDICAL_ATTENDANT NVARCHAR(250),
	@EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT NVARCHAR(250),
	@EVACUATION_TRANSPORTATION_TYPE_CODE VARCHAR(100),
	@EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM VARCHAR(100),
	@EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM_NAME VARCHAR(100),
	@EVACUATION_TRANSPORTATION_TYPE_DISPLAY_NAME VARCHAR(100),
	@EVACUATION_TRANSPORTATION_PROVIDER_CODE VARCHAR(100),
	@EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM VARCHAR(100),
	@EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM_NAME VARCHAR(100),
	@EVACUATION_TRANSPORTATION_PROVIDER_DISPLAY_NAME VARCHAR(100),
	@EVACUATION_TRANSPORTATION_COMMENTS NVARCHAR(250),
	@EVACUATION_DESTINATION_ADDRESS NVARCHAR(250),
	@EVACUATION_DESTINATION_CITY_STATE NVARCHAR(250),
	@EVACUATION_DESTINATION_POC_TELEPHONE NVARCHAR(100),
	@EVACUATION_ORIGINATOR_POC_TELEPHONE NVARCHAR(100),
	@EVACUATION_COMMENTS NVARCHAR(500),
	@EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER INT,
	@EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER INT,
	@EVACUATION_ARRIVAL_TIME DATETIME,
	@EVACUATION_VEHICLE_ID NVARCHAR(250),
	@EVACUATION_VEHICLE_SEAT_POSITION NVARCHAR(250),
	@EVACUATION_MA_TELEPHONE nvarchar(100),
	@EVACUATION_NMA_TELEPHONE nvarchar(100),
	@EVACUATION_ORIGINATING_FACILITY_NAME nvarchar(250),
	@EVACUATION_ORIGINATING_ADDRESS nvarchar(250),
	@EVACUATION_ORIGINATING_CITY_STATE nvarchar(250),
	@EVACUATION_VEHICLE_OPERATOR_NAME nvarchar(250),
	@EVACUATION_VEHICLE_OPERATOR_TELEPHONE nvarchar(100),
	@DATE_OF_SCREENING datetime,
	@CONTACT_PHONE_NUMBER nvarchar(100),
	@VETERAN_PREFERENCE nvarchar(50),
	@MENTAL_HEALTH_COMMENTS nvarchar(500),
	@PATIENT_FLOW_COMMENTS nvarchar(500),
	@FEE_ACCEPTED nvarchar(50),
	@FEE_ACCEPTING_MD nvarchar(250)
AS
SET NOCOUNT ON

BEGIN

	DECLARE @WAITING_AREA_ID INT, @FEE_DISPOSITION_ID INT, @CONTRACT_FEE_ID INT, @AUTHORIZED_FEE_ID INT, @SERVICE_RECEIVING_FEE_ID INT, 
			@REASON_USING_FEE_ID INT, @EVACUATION_DISPOSITION_STATUS_ID INT, @EVACUATION_TRANSPORTATION_TYPE_ID INT,
			@EVACUATION_TRANSPORTATION_PROVIDER_ID INT 	

	EXEC dbo.usp_Update_Act
		@PATIENT_UID = @PATIENT_UID,
		@CREATION_DATE = @CREATION_DATE,
		@CANCELED_DATE = @CANCELED_DATE,
		@PARENT_ACT_ID = @PARENT_ACT_ID,
		@FLOW_ID = @FLOW_ID,
		@DOMAIN_ID = @DOMAIN_ID,
		@IEN = @IEN,
		@ID = @ACT_ID

	--WAITING AREA CONCEPT EXISTENCE CHECK
	EXEC DBO.USP_MANAGE_CONCEPT 
		@CODE = @WAITING_AREA_CODE, 
		@CODE_SYSTEM = @WAITING_AREA_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @WAITING_AREA_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @WAITING_AREA_DISPLAY_NAME, 
		@ID = @WAITING_AREA_ID  OUTPUT

	--FEE DISPOSITION CONCEPT EXISTENCE CHECK
	EXEC DBO.USP_MANAGE_CONCEPT 
		@CODE = @FEE_DISPOSITION_CODE, 
		@CODE_SYSTEM = @FEE_DISPOSITION_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @FEE_DISPOSITION_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @FEE_DISPOSITION_DISPLAY_NAME, 
		@ID = @FEE_DISPOSITION_ID OUTPUT

	--CONTRACT FEE CONCEPT EXISTENCE CHECK
	EXEC DBO.USP_MANAGE_CONCEPT 
		@CODE = @CONTRACT_FEE_CODE, 
		@CODE_SYSTEM = @CONTRACT_FEE_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @CONTRACT_FEE_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @CONTRACT_FEE_DISPLAY_NAME, 
		@ID = @CONTRACT_FEE_ID OUTPUT

	--AUTHORIZED FEE CONCEPT EXISTENCE CHECK
	EXEC DBO.USP_MANAGE_CONCEPT 
		@CODE = @AUTHORIZED_FEE_CODE,
		@CODE_SYSTEM = @AUTHORIZED_FEE_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @AUTHORIZED_FEE_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @AUTHORIZED_FEE_DISPLAY_NAME, 
		@ID = @AUTHORIZED_FEE_ID OUTPUT

	--SERVICE RECEIVING FEE CONCEPT EXISTENCE CHECK
	EXEC DBO.USP_MANAGE_CONCEPT 
		@CODE = @SERVICE_RECEIVING_FEE_CODE, 
		@CODE_SYSTEM = @SERVICE_RECEIVING_FEE_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @SERVICE_RECEIVING_FEE_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @SERVICE_RECEIVING_FEE_DISPLAY_NAME, 
		@ID = @SERVICE_RECEIVING_FEE_ID OUTPUT

	--REASON USING FEE CONCEPT EXISTENCE CHECK
	EXEC DBO.USP_MANAGE_CONCEPT 
		@CODE = @REASON_USING_FEE_CODE, 
		@CODE_SYSTEM = @REASON_USING_FEE_CODE_SYSTEM, 
		@CODE_SYSTEM_NAME = @REASON_USING_FEE_CODE_SYSTEM_NAME, 
		@DISPLAY_NAME = @REASON_USING_FEE_DISPLAY_NAME, 
		@ID = @REASON_USING_FEE_ID OUTPUT
		
	IF @IS_EVACUATION_PATIENT IS NOT NULL AND @IS_EVACUATION_PATIENT = 1
		BEGIN	 	
		 	-- EVACUATION DISPOSITION STATUS EXISTENCE CHECK	
			EXEC dbo.USP_MANAGE_CONCEPT 
				@CODE = @EVACUATION_DISPOSITION_STATUS_CODE, 
				@CODE_SYSTEM = @EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM,
				@CODE_SYSTEM_NAME = @EVACUATION_DISPOSITION_STATUS_CODE_SYSTEM_NAME,
				@DISPLAY_NAME = @EVACUATION_DISPOSITION_STATUS_DISPLAY_NAME,
				@ID = @EVACUATION_DISPOSITION_STATUS_ID  OUTPUT
				
			-- EVACUATION TRANSPORTATION TYPE EXISTENCE CHECK	
			EXEC dbo.USP_MANAGE_CONCEPT 
				@CODE = @EVACUATION_TRANSPORTATION_TYPE_CODE, 
				@CODE_SYSTEM = @EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM,
				@CODE_SYSTEM_NAME = @EVACUATION_TRANSPORTATION_TYPE_CODE_SYSTEM,
				@DISPLAY_NAME = @EVACUATION_TRANSPORTATION_TYPE_DISPLAY_NAME,
				@ID = @EVACUATION_TRANSPORTATION_TYPE_ID  OUTPUT
				
			-- EVACUATION TRANSPORTATION PROVIDER EXISTENCE CHECK	
			EXEC dbo.USP_MANAGE_CONCEPT 
				@CODE = @EVACUATION_TRANSPORTATION_PROVIDER_CODE, 
				@CODE_SYSTEM = @EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM,
				@CODE_SYSTEM_NAME = @EVACUATION_TRANSPORTATION_PROVIDER_CODE_SYSTEM_NAME,
				@DISPLAY_NAME = @EVACUATION_TRANSPORTATION_PROVIDER_DISPLAY_NAME,
				@ID = @EVACUATION_TRANSPORTATION_PROVIDER_ID  OUTPUT
		END
	ELSE
		BEGIN
			SET @EVACUATION_DISPOSITION_STATUS_ID = NULL
			SET @EVACUATION_TRANSPORTATION_TYPE_ID = NULL
			SET @EVACUATION_TRANSPORTATION_PROVIDER_ID = NULL
		END
	
	UPDATE WAITING_LIST
		SET
			FACILITY_UID = @FACILITY_UID, 
			WAITING_AREA_ID = @WAITING_AREA_ID, 
			PROBLEM = @PROBLEM, 
			FEE_DISPOSITION_ID = @FEE_DISPOSITION_ID, 
			CONTRACT_FEE_ID = @CONTRACT_FEE_ID, 
			AUTHORIZED_FEE_ID = @AUTHORIZED_FEE_ID, 
			SERVICE_RECEIVING_FEE_ID = @SERVICE_RECEIVING_FEE_ID, 
			REASON_USING_FEE_ID = @REASON_USING_FEE_ID, 
			FEE_COMMENTS = @FEE_COMMENTS, 
			REMOVED_DATE = @REMOVED_DATE, 
			TYPE_OF_BED_WARD = @TYPE_OF_BED_WARD,
			REQUESTED_BED_UID = @REQUESTED_BED_UID,
			REQUESTED_BED_DATE = @REQUESTED_BED_DATE,
			REQUESTED_DATE = @REQUESTED_DATE,
			VISTA_SITE_UID = @VISTA_SITE_UID,
			IS_IN_HOUSE = @IS_IN_HOUSE,
			LAST_EDIT_BY = @LAST_EDIT_BY,
			COMMENTS = @COMMENTS,
			IS_BED_IN_ISOLATION = @IS_BED_IN_ISOLATION,
			WAIT_TIME_ALERT_DATE= @WAIT_TIME_ALERT_DATE,
			IS_COMMUNITY_LIVING_CENTER = @IS_COMMUNITY_LIVING_CENTER,
			IS_EVACUATION_PATIENT = @IS_EVACUATION_PATIENT,
			IS_MENTAL_HEALTH_PATIENT = @IS_MENTAL_HEALTH_PATIENT,
			EVACUATION_DISPOSITION_STATUS_ID = @EVACUATION_DISPOSITION_STATUS_ID,
			EVACUATION_EXPECTED_DATE = @EVACUATION_EXPECTED_DATE,
			EVACUATION_ACTUAL_DATE = @EVACUATION_ACTUAL_DATE,
			EVACUATION_REASON_FOR_DELAY = @EVACUATION_REASON_FOR_DELAY,
			EVACUATION_TRANSFER_EVACUATE_TO = @EVACUATION_TRANSFER_EVACUATE_TO,
			EVACUATION_EQUIP_SUPPLY_REQUIREMENTS =@EVACUATION_EQUIP_SUPPLY_REQUIREMENTS,
			EVACUATION_TRANSPORTATION_CARE_LEVEL =@EVACUATION_TRANSPORTATION_CARE_LEVEL,
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT=@EVACUATION_ENROUTE_MEDICAL_ATTENDANT,
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT =@EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT,
			EVACUATION_TRANSPORTATION_TYPE_ID = @EVACUATION_TRANSPORTATION_TYPE_ID,
			EVACUATION_TRANSPORTATION_PROVIDER_ID = @EVACUATION_TRANSPORTATION_PROVIDER_ID,
			EVACUATION_TRANSPORTATION_COMMENTS = @EVACUATION_TRANSPORTATION_COMMENTS,
			EVACUATION_DESTINATION_ADDRESS = @EVACUATION_DESTINATION_ADDRESS,
			EVACUATION_DESTINATION_CITY_STATE =@EVACUATION_DESTINATION_CITY_STATE,
			EVACUATION_DESTINATION_POC_TELEPHONE =@EVACUATION_DESTINATION_POC_TELEPHONE,
			EVACUATION_ORIGINATOR_POC_TELEPHONE =@EVACUATION_ORIGINATOR_POC_TELEPHONE,
			EVACUATION_COMMENTS =@EVACUATION_COMMENTS,
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER = @EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER,
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER = @EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER,
			EVACUATION_ARRIVAL_TIME = @EVACUATION_ARRIVAL_TIME,
			EVACUATION_VEHICLE_ID = @EVACUATION_VEHICLE_ID,
			EVACUATION_VEHICLE_SEAT_POSITION = @EVACUATION_VEHICLE_SEAT_POSITION,
			EVACUATION_MA_TELEPHONE = @EVACUATION_MA_TELEPHONE,
			EVACUATION_NMA_TELEPHONE = @EVACUATION_NMA_TELEPHONE,
			EVACUATION_ORIGINATING_FACILITY_NAME = @EVACUATION_ORIGINATING_FACILITY_NAME,
			EVACUATION_ORIGINATING_ADDRESS = @EVACUATION_ORIGINATING_ADDRESS,
			EVACUATION_ORIGINATING_CITY_STATE = @EVACUATION_ORIGINATING_CITY_STATE,
			EVACUATION_VEHICLE_OPERATOR_NAME = @EVACUATION_VEHICLE_OPERATOR_NAME,
			EVACUATION_VEHICLE_OPERATOR_TELEPHONE = @EVACUATION_VEHICLE_OPERATOR_TELEPHONE,
			DATE_OF_SCREENING = @DATE_OF_SCREENING,
			CONTACT_PHONE_NUMBER = @CONTACT_PHONE_NUMBER,
			VETERAN_PREFERENCE = @VETERAN_PREFERENCE,
			MENTAL_HEALTH_COMMENTS = @MENTAL_HEALTH_COMMENTS,
			PATIENT_FLOW_COMMENTS = @PATIENT_FLOW_COMMENTS,
			FEE_ACCEPTED = @FEE_ACCEPTED,
			FEE_ACCEPTING_MD = @FEE_ACCEPTING_MD
			WHERE ACT_ID = @ACT_ID

	IF @@ERROR<>0 RETURN
END

GO


